#pragma once
#include "Config.h"
#include "Engine/Vec2.h"
#include "Engine/ECS/Entity.h"
#include "Engine/ECS/ImageComponent.h"
#include "Engine/ECS/TransformComponent.h"
#include "Engine/ECS/CollisionComponent.h"
#include "Engine/ECS/PhysicsComponent.h"
#include "Breakout/BreakoutScene.h"

class Ball : public Entity {
public:
  Ball(BreakoutScene& Scene) : Entity{Scene} {
    Transform = AddComponent<TransformComponent>();
    Transform->SetPosition({
      7.4f * Scene::PIXELS_PER_METER,
      6.8f * Scene::PIXELS_PER_METER
    });
    Transform->SetScale(0.3f);

    Physics = AddComponent<PhysicsComponent>();
    Physics->SetGravity({0.f, 0.f});
    Physics->SetVelocity(
      Vec2{1.f, -2.f}.Normalize()
        * Config::Breakout::BALL_SPEED
        * float(Scene::PIXELS_PER_METER)
    );

    Collision = AddComponent<CollisionComponent>();
    Collision->SetSize(
      1.2f * Scene::PIXELS_PER_METER,
      1.2f * Scene::PIXELS_PER_METER
    );

    AddComponent<ImageComponent>(
      Config::BASE_PATH + "Assets/Grey.png"
    );
    SetIsPaused(true);
  }

  void HandleCollision(Entity& Other) override;

  void HandleEvent(const SDL_Event& E) override {
    if (
      E.type == SDL_EVENT_KEY_DOWN &&
      E.key.key == SDLK_SPACE &&
      GetScene().GetState() == GameState::InProgress
    ) {
      SetIsPaused(false);
    } else if (
      E.type == UserEvents::GAME_WON ||
      E.type == UserEvents::GAME_LOST
    ) {
      SetIsPaused(true);
    }
  }

private:
  void SetIsPaused(bool isPaused) {
    Physics->SetIsEnabled(!isPaused);
    Collision->SetIsEnabled(!isPaused);
  }

  TransformComponent* Transform;
  CollisionComponent* Collision;
  PhysicsComponent* Physics;
};
