#include "Breakout/Ball.h"
#include "Breakout/Paddle.h"
#include "Engine/Vec2.h"

void Ball::HandleCollision(Entity& Other) {
  if (dynamic_cast<Paddle*>(&Other)) {
    return;
  }
  SDL_FRect Intersection;
  Collision->GetCollisionRectangle(
    *Other.GetComponent<CollisionComponent>(),
    &Intersection
  );

  if (!(Physics && Transform)) {
    return;
  }

  bool IsVertical{
    Intersection.w > Intersection.h
  };

  Vec2 CurrentPos{Transform->GetPosition()};
  if (IsVertical) {
    if (Physics->GetVelocity().y < 0)
      CurrentPos.y += Intersection.h;
    else
      CurrentPos.y -= Intersection.h;
  } else {
    if (Physics->GetVelocity().x > 0)
      CurrentPos.x -= Intersection.w;
    else
      CurrentPos.x += Intersection.w;
  }
  Transform->SetPosition(CurrentPos);

  TransformComponent* OtherTransform{
    Other.GetComponent<TransformComponent>()
  };
  Vec2 RelativePosition{
    Transform->GetPosition() -
    OtherTransform->GetPosition()
  };

  Vec2 Normal{
    IsVertical ? Vec2{
      0.0f,
      (RelativePosition.y > 0) ? 1.0f : -1.0f
    } : Vec2{
      (RelativePosition.x > 0) ? 1.0f : -1.0f,
      0.0f
    }
  };

  Vec2 Velocity{Physics->GetVelocity()};
  float DotProduct{
    Velocity.x * Normal.x +
    Velocity.y * Normal.y
  };
  if (DotProduct < 0) {
    Physics->SetVelocity(
      Velocity - Normal * (DotProduct * 2)
    );
  }
}